\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 23))
  markup-system-spacing = #'((basic-distance . 30))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 8\mm
  %ragged-right = ##f
  %ragged-last-bottom=##f
  %system-count = #5
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Am văzut lumina"
  subtitle = "(2)"
  %subsubtitle = "Op. 21"
  %poet = "Vasile Militaru (1885 - 1959)"
  %composer =  "12.03.2019 Erlangen"
  %arranger = "io"
  %meter = "Allegretto"
  tagline=""
}

global = {
  \key f \major
  \autoBeamOn
  %\cadenzaOn
  %\time 2/4
  \partial 4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  Vă -- zut -- am lu -- mi -- na cea a -- de -- vă -- ra -- tă, __
  pri -- mit -- am Du -- hul cel ce -- resc,
  a -- flat -- am cre -- din -- ţa cea a -- de -- vă -- ra -- tă, __
  ne -- des -- păr -- ţi -- tei Sfin -- tei Tre -- imi __ în -- chi -- nân -- du -- ne,
  că a -- ceas -- ta ne-a mân -- tu -- it pe noi.  
  Doam -- ne mi -- lu -- ieş -- te.
  Doam -- ne mi -- lu -- ieş -- te.
  Ți -- e, Doam -- ne. A -- min.
  În -- tru nu -- me -- le Dom -- nu -- lui. 
}

menWords = \lyricmode {
  Vă -- zut -- am lu -- mi -- na cea a -- de -- vă -- ra -- tă, __
  pri -- mit -- am Du -- hul cel ce -- resc,
  a -- flat -- am cre -- din -- ţa cea a -- de -- vă -- ra -- tă, __
  %ne -- des -- păr -- ţi -- tei Sfin -- tei Tre -- imi __ 
  în -- chi -- nân -- du -- ne,
  că a -- ceas -- ta ne-a mân -- tu -- it pe noi.  
  Doam -- ne mi -- lu -- ieş -- te.
  Doam -- ne mi -- lu -- ieş -- te.
  Ți -- e, Doam -- ne. A -- min.
  În -- tru nu -- me -- le Dom -- nu -- lui. 
}

sopMusic = \relative c' {
  f4 a2 a4 a b2 a b4 c d b c2 c( c4) \breathe
  a4 a a b a b h c2. \breathe
  f,4 a2 a4 a b2 a b4 c d b c2 c( c4) \breathe
  a4 a a b2 a b4( c) d d c2( es4 d) c b a g f2
  f4 f g2 f4 f g a g2^\markup "rall." g4( b) a2 \fermata  
  \bar "|."
}

altMusic = \relative c' {
  f4 f2 f4 f g2 f g4 g g g a2 a( a4)
  a4 a a b a g g a2.
  f4 f2 f4 f g2 f g4 a b g a2 a( a4)
  a4 a a g2 f g g4 g a1 a4 g f e f2
  f4 f e2 f4 f e f e2 e f
}

tenorMusic = \relative c' {
  a4 c2 c4 c d2 c c4 c d e f2 f( f4)
  f,4 f f g f e f8( g) a2.
  a4 c2 c4 c des2 c c4 c d e f2 f( f4)
  \skip 2. d,1\rest d1\rest d1\rest
  %d,2.\rest d1\rest d1\rest d1\rest
  f4 g f e f2 f4 f g2 f4 f g a b2 b a  
}

bassMusic = \relative c {
  f4 f2 f4 f b,2 f'2 c4 c c c f2 f( f4)
  f4 f f c c c c f2.
  f4 f2 f4 f es2 f2 c4 c c c f2 f( f4)
  d2.\rest d1\rest d1\rest d1\rest
  f4 b, c c f2 f4 f c2 
  d4 d c c c2 c f
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altMusic }
      >>
    
    \new Staff <<
      \clef bass
      %\new Voice { \global \bassMusic }
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
      >>
    
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
   \tempo 4 = 80
   \context { \Voice \remove "Dynamic_performer" }
}

\score {
  %\unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}